#!/bin/sh

############################################## 
#
# Usage: ./create_basic_domain_service.sh 
#
############################################## 

SCRIPT=$(readlink -f $0)
SCRIPT_PATH=$(dirname $SCRIPT)
 
#. ${SCRIPT_PATH}/../set_environment_variables.sh
 
if [ ! -d "${TEMPORARY_DIRECTORY}" ]; then
	mkdir -p ${TEMPORARY_DIRECTORY}
fi
 
create_basic_domain() {
	${ORACLE_COMMON_HOME}/common/bin/wlst.sh -loadProperties ${CUSTOM_PROPERTIES} ${SCRIPT_PATH}/create_basic_domain.py
 
	mkdir -p ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/nodemanager/security
	cp ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/security/DemoIdentity.jks ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/nodemanager/security
}
 
# Change memory settings alters the setDomainEnv file and adds the following
#
#ADMIN_SERVER_MEM_ARGS="-Xms512m -Xmx512m -XX:PermSize=256m"
#SERVER_MEM_ARGS="-Xms512m -Xmx512m -XX:PermSize=256m"
#COHERENCE_SERVER_MEM_ARGS="-Xms512m -Xmx512m -XX:PermSize=256m"
#COHERENCE_MONITORING_ARGS="-Dtangosol.coherence.management=all -Dtangosol.coherence.management.remote=true"
#GARBAGE_COLLECTOR_ARGS="-XX:NewRatio=3 -XX:SurvivorRatio=128 -XX:MaxTenuringThreshold=0 -XX:+UseParallelGC -XX:MaxGCPauseMillis=200 -XX:GCTimeRatio=19 -XX:+UseParallelOldGC -XX:+UseTLAB"
#LARGE_PAGES_ARGS="-XX:LargePageSizeInBytes=2048k -XX:+UseLargePages"
#
#if [ "${ADMIN_URL}" = "" ] ; then
# USER_MEM_ARGS="${ADMIN_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS}"
#else
# case ${SERVER_NAME} in
# server_*)
# USER_MEM_ARGS="${SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS}"
# ;;
# coherence_server_1)
# USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS} ${COHERENCE_MONITORING_ARGS}"
# ;;
# coherence_server_*)
# USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS}"
# ;;
# esac
#fi
#export USER_MEM_ARGS
#
# The Xms and Xms parameters are configurable by using the ADMIN_SERVER_HEAP_SIZE, MANAGED_SERVER_HEAP_SIZE, and
# COHERENCE_SERVER_HEAP_SIZE variables.
 
change_memory_settings() {
	echo 'CHANGE MEMORY SETTINGS'
 
	ADMIN_SERVER_HEAP_SIZE=512m
	MANAGED_SERVER_HEAP_SIZE=512m
	COHERENCE_SERVER_HEAP_SIZE=512m
 
	sed -i.bak -e '/export WL_HOME/ a\\nADMIN_SERVER_MEM_ARGS="-Xms'${ADMIN_SERVER_HEAP_SIZE}' -Xmx'${ADMIN_SERVER_HEAP_SIZE}' -XX:PermSize=256m"\nSERVER_MEM_ARGS="-Xms'${MANAGED_SERVER_HEAP_SIZE}' -Xmx'${MANAGED_SERVER_HEAP_SIZE}' -XX:PermSize=256m"\nCOHERENCE_SERVER_MEM_ARGS="-Xms'${COHERENCE_SERVER_HEAP_SIZE}' -Xmx'${COHERENCE_SERVER_HEAP_SIZE}' -XX:PermSize=256m"\nCOHERENCE_MONITORING_ARGS="-Dtangosol.coherence.management=all -Dtangosol.coherence.management.remote=true"\nGARBAGE_COLLECTOR_ARGS="-XX:NewRatio=3 -XX:SurvivorRatio=128 -XX:MaxTenuringThreshold=0 -XX:+UseParallelGC -XX:MaxGCPauseMillis=200 -XX:GCTimeRatio=19 -XX:+UseParallelOldGC -XX:+UseTLAB"\nLARGE_PAGES_ARGS="-XX:LargePageSizeInBytes=2048k -XX:+UseLargePages"\n\nif [ "${ADMIN_URL}" = "" ] ; then\n USER_MEM_ARGS="${ADMIN_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS}"\nelse\n case ${SERVER_NAME} in\n server_*)\n USER_MEM_ARGS="${SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS}"\n ;;\n coherence_server_1)\n USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS} ${COHERENCE_MONITORING_ARGS}"\n ;;\n coherence_server_*)\n USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${LARGE_PAGES_ARGS}"\n ;;\n esac\nfi\nexport USER_MEM_ARGS' \
-e '/DERBY_FLAG="true"/ s:DERBY_FLAG="true":DERBY_FLAG="false":' ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/bin/setDomainEnv.sh
}
 
change_memory_settings_using_overridefile() {
	echo 'CHANGE DERBY FLAG'
	sed -i -e '/DERBY_FLAG="true"/ s:DERBY_FLAG="true":DERBY_FLAG="false":' ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/bin/setDomainEnv.sh
	 
	echo 'CHANGE MEMORY SETTINGS'
	ADMIN_SERVER_HEAP_SIZE=512m
	ADMIN_SERVER_PERM_SIZE=256m
	MANAGED_SERVER_HEAP_SIZE=512m
	MANAGED_SERVER_PERM_SIZE=256m
	COHERENCE_SERVER_HEAP_SIZE=512m
	COHERENCE_SERVER_PERM_SIZE=256m
	 
	touch ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/bin/setUserOverrides.sh
	chmod u+x ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/bin/setUserOverrides.sh
	 
	echo '#!/bin/sh
 
ADMIN_SERVER_MEM_ARGS="-Xms'${ADMIN_SERVER_HEAP_SIZE}' -Xmx'${ADMIN_SERVER_HEAP_SIZE}' -XX:PermSize='${ADMIN_SERVER_PERM_SIZE}'"
SERVER_MEM_ARGS="-Xms'${MANAGED_SERVER_HEAP_SIZE}' -Xmx'${MANAGED_SERVER_HEAP_SIZE}' -XX:PermSize='${MANAGED_SERVER_PERM_SIZE}'"
COHERENCE_SERVER_MEM_ARGS="-Xms'${COHERENCE_SERVER_HEAP_SIZE}' -Xmx'${COHERENCE_SERVER_HEAP_SIZE}' -XX:PermSize='${COHERENCE_SERVER_PERM_SIZE}'"
MONITORING_ARGS="-XX:+UnlockCommercialFeatures -XX:+FlightRecorder"
COHERENCE_MONITORING_ARGS="-Dtangosol.coherence.management=all -Dtangosol.coherence.management.remote=true"
GARBAGE_COLLECTOR_ARGS="-XX:NewRatio=3 -XX:SurvivorRatio=128 -XX:MaxTenuringThreshold=0 -XX:+UseParallelGC -XX:MaxGCPauseMillis=200 -XX:GCTimeRatio=19 -XX:+UseParallelOldGC -XX:+UseTLAB"
LARGE_PAGES_ARGS="-XX:LargePageSizeInBytes=2048k -XX:+UseLargePages"
 
if [ "${ADMIN_URL}" = "" ] ; then
	USER_MEM_ARGS="${ADMIN_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS}"
else
	case ${SERVER_NAME} in
		server_*)
			USER_MEM_ARGS="${SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${MONITORING_ARGS}"
		;;
		coherence_server_1)
			USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS} ${COHERENCE_MONITORING_ARGS}"
		;;
		coherence_server_*)
			USER_MEM_ARGS="${COHERENCE_SERVER_MEM_ARGS} ${GARBAGE_COLLECTOR_ARGS}"
		;;
	esac
fi
export USER_MEM_ARGS
 
#if [ "${WEBLOGIC_EXTENSION_DIRS}" != "" ] ; then
# WEBLOGIC_EXTENSION_DIRS="${WEBLOGIC_EXTENSION_DIRS}${CLASSPATHSEP}${DOMAIN_HOME}/lib"
#else
# WEBLOGIC_EXTENSION_DIRS="${DOMAIN_HOME}/lib"
#fi
#export WEBLOGIC_EXTENSION_DIRS' > ${CONFIGURATION_HOME}/domains/${DOMAIN_NAME}/bin/setUserOverrides.sh
}
 
create_basic_domain
 
change_memory_settings
 
#change_memory_settings_using_overridefile

